import math
operators = {}
class operator:
  def __init__(self,name,func,operands):
    self.func = func
    self.operands = operands
    self.remove = True
    self.insert = True
    self.operandType = 'operand'
    operators[name] = self
opSqrt = operator('sqrt',math.sqrt,1)
opExit = operator('exit',exit,0)
opPow = operators['^'] = operator('**',math.pow,2)
"""Built in Operators"""
def printCurrent(currentList):
  print str(currentList[:-1])[1:-1]

opPrint = operator('print',printCurrent,0)
opPrint.operandType = 'currentList'

def clearList(currentList):
  del currentList[:]

opClear = operator('clear',clearList,0)
opClear.remove = False
opClear.operandType = 'currentList'
def times(x,y):
  return x * y

opMult = operator('*',times,2)

def divide(x,y):
  result =  x / float(y)
  if result % 1 == 0:
    return int(result)
  return result

opDivide = operator('/',divide,2)

def add(x,y):
  return x + y

opAdd = operator('+',add,2)

def subtract(x,y):
  return x - y

opSubt = operator('-',subtract,2)
"""User Defined Operators"""
# Define your own operators here!
# Ex. an operator square:
def square(x):
  return x ** 2
# Then add your operator to the dictionary!
# operator(<==name of operator==>, <==function used==>, <==number of operands==>
# You can also store your operator in a variable to easily modify options.
opSquare = operator('sqr', square, 1)
# If you want to modify any options, do operators[<==name==>].<==option name==> = <==value==>

